set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102383';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      '1224433',
      22,
      NULL,
      1.110145,
      1,
      NULL,
      1.651250,
      '10-14-1990',
      NULL,
      NULL,
      1.844962,
      NULL,
      NULL,
      1,
      1.849518,
      0,
      0,
      1.855890,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1.873355,
      0,
      0,
      2.190383,
      0,
      0,
      1,
      1,
      0,
      4,
      NULL,
      3.424191,
      0.094416,
      1,
      0.846424,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.489452,
      1.993698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.669776,
      0.600793,
      2.251095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223308,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      0.775296,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.040417,
      0.624627,
      0.507803,
      1.129760,
      1,
      NULL,
      0.328446,
      NULL,
      1,
      NULL,
      NULL,
      0.824200,
      3,
      0,
      0,
      0.407208,
      4,
      2.067354,
      0,
      0.023522,
      5.453814,
      0.021586,
      1,
      4.511801,
      5,
      0.576376,
      2.519583,
      5.052357,
      5.879103,
      0.931331,
      0.375153,
      2,
      14,
      1,
      0.217102,
      NULL,
      NULL,
      5,
      0.534281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491409,
      1,
      1,
      0.744770,
      1.266318,
      0.445422,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.902958,
      1.328016,
      0.685241,
      1,
      1.188173,
      NULL,
      1.244089,
      1,
      NULL,
      NULL,
      NULL,
      0.978899,
      0.202023,
      3,
      NULL,
      NULL,
      0,
      0.133495,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.964227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884472,
      1.423072,
      1,
      NULL,
      1.170749,
      1.509485,
      0,
      1.398211,
      0.324229,
      0.957524,
      0.092111,
      1.056074,
      NULL,
      NULL,
      1,
      0,
      0.244268,
      1.453055,
      1,
      0.513800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '01313',
      NULL,
      '',
      1.874815,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


