set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102383';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02',
      22.053444,
      7,
      '4203314',
      58,
      6,
      1.131558,
      0,
      '412440',
      4.164168,
      ' 3-24-1982',
      NULL,
      29.775652,
      NULL,
      NULL,
      NULL,
      0,
      3.168902,
      1.013349,
      0,
      1,
      2,
      0,
      1.711547,
      0,
      4.798037,
      1.755721,
      1,
      NULL,
      0.089300,
      2.145876,
      NULL,
      NULL,
      0,
      0,
      0.488959,
      0.537449,
      7,
      0,
      2,
      1,
      NULL,
      0.112705,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4.604683,
      NULL,
      3,
      NULL,
      2,
      2.688317,
      NULL,
      NULL,
      2,
      0.564761,
      3,
      NULL,
      1,
      1,
      1,
      2.575347,
      3,
      2,
      1.518585,
      0.227415,
      2,
      0,
      1,
      2.109569,
      NULL,
      NULL,
      NULL,
      1.993140,
      NULL,
      NULL,
      1.198660,
      1,
      0.072963,
      0.957922,
      NULL,
      NULL,
      1.004840,
      NULL,
      0.005578,
      0,
      0,
      1.123338,
      0,
      0,
      0.605429,
      NULL,
      0,
      1.737524,
      NULL,
      NULL,
      0.422068,
      4,
      1,
      0.419067,
      0,
      NULL,
      2.690240,
      0.184364,
      NULL,
      1.149825,
      1,
      NULL,
      NULL,
      0,
      4,
      1.082706,
      0,
      3,
      NULL,
      4.733012,
      3.950802,
      4,
      NULL,
      3,
      3.641896,
      NULL,
      2.981929,
      0.592208,
      NULL,
      1.332939,
      1,
      6.324949,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.506727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813138,
      0.413086,
      0,
      NULL,
      NULL,
      NULL,
      4.717734,
      0.931469,
      3,
      0,
      0,
      0,
      1.425580,
      NULL,
      NULL,
      NULL,
      0.315024,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.606933,
      2.962838,
      3,
      1,
      1.466582,
      2,
      0,
      3,
      1.113880,
      0.771245,
      0,
      1,
      1.773299,
      1,
      NULL,
      0.810631,
      0.281738,
      0.209482,
      0,
      0.636391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.933091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


