set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102383';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-12-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43',
      10,
      14.749621,
      NULL,
      NULL,
      2,
      NULL,
      0,
      '213213',
      1,
      ' 9- 6-1992',
      2.063518,
      38.304700,
      0.916536,
      NULL,
      NULL,
      0,
      0.213692,
      NULL,
      1.971188,
      NULL,
      3.706799,
      0.888288,
      1.917819,
      1,
      3,
      1,
      0,
      0.796365,
      NULL,
      2,
      8,
      0,
      NULL,
      0,
      1,
      1.455959,
      NULL,
      1,
      3.578343,
      1.730838,
      0,
      1.718344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.015845,
      0.303796,
      0.154920,
      3,
      2.567117,
      0,
      3,
      0.694318,
      3.603081,
      0,
      0,
      0.471307,
      1.155313,
      1,
      NULL,
      1.073406,
      2.333581,
      1.263938,
      1,
      1,
      NULL,
      5,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052598,
      NULL,
      4.258842,
      0,
      0,
      0.041381,
      1.063628,
      0.598625,
      0,
      1.998863,
      1,
      0,
      0,
      0.691120,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      6,
      NULL,
      1.731501,
      4,
      1,
      NULL,
      0.890926,
      0,
      1,
      NULL,
      0,
      4.145154,
      0,
      0.769923,
      1,
      NULL,
      4.568193,
      NULL,
      6,
      7,
      6,
      2.076265,
      6.811497,
      3,
      5,
      NULL,
      1,
      0.559531,
      1.711896,
      1,
      2.111341,
      0.190775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.837699,
      NULL,
      0,
      1,
      0,
      NULL,
      1.888232,
      0.836671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.223430,
      0.460905,
      NULL,
      3.999897,
      2.036286,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.966485,
      0.954717,
      1.044509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.559070,
      1,
      NULL,
      3,
      NULL,
      1.069048,
      NULL,
      NULL,
      NULL,
      1.882541,
      1.246112,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.733952,
      0.128147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '33221',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


