set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8604250';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '324',
      '43234210',
      0.030284,
      48.225075,
      '1014422',
      5.863404,
      3,
      NULL,
      3,
      '013301',
      NULL,
      ' 4- 2-1983',
      NULL,
      NULL,
      0.609107,
      NULL,
      NULL,
      2.832009,
      1.445358,
      1.610469,
      1.669539,
      NULL,
      1.129284,
      1.167777,
      0,
      0.759064,
      NULL,
      NULL,
      0,
      1.842267,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1,
      0.185027,
      1,
      4.582990,
      1,
      NULL,
      0,
      0.981725,
      1.249538,
      NULL,
      NULL,
      1.334187,
      NULL,
      NULL,
      2.451672,
      NULL,
      1,
      0,
      1.223911,
      1.360935,
      2,
      0,
      NULL,
      NULL,
      0,
      0.115345,
      1,
      NULL,
      NULL,
      NULL,
      0.203666,
      NULL,
      0,
      NULL,
      0,
      0,
      4.179233,
      0,
      NULL,
      1.300096,
      1.493225,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      4,
      1,
      3.405906,
      1,
      1,
      1.905536,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0.969508,
      0.506419,
      NULL,
      NULL,
      1.492966,
      NULL,
      NULL,
      0,
      0.741771,
      1.089420,
      0.092086,
      0,
      0,
      1.386452,
      1,
      1,
      1.095819,
      1,
      1,
      1,
      1.373106,
      1,
      NULL,
      2.254328,
      5,
      3,
      4,
      NULL,
      2.664399,
      5.796724,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.346805,
      NULL,
      1,
      0,
      0.780253,
      0,
      1.977153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.967591,
      NULL,
      1.304999,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.210031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.242464,
      1,
      NULL,
      3,
      1.145607,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.048665,
      1,
      0,
      0.286578,
      1.329893,
      1,
      1.722855,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '40221',
      NULL,
      '',
      1.413729,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      3,
      1,
      NULL,
      1,
      0.787990,
      3.735264,
      2.330820,
      1.684728,
      0.915176);
commit;
end;
/


