set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '3200333',
      14,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.658479,
      NULL,
      0.780407,
      NULL,
      0,
      1.611847,
      0,
      0.689017,
      0,
      NULL,
      1.301689,
      0,
      0,
      1,
      7,
      NULL,
      0,
      1,
      0,
      3.955420,
      4.304034,
      0,
      2.393145,
      0,
      7,
      0.809839,
      9,
      NULL,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.820968,
      0,
      1.608683,
      3,
      0.822348,
      0.473970,
      0,
      0.268379,
      0,
      0,
      NULL,
      NULL,
      1.383536,
      0,
      2.784131,
      1.454349,
      2,
      1.503355,
      1,
      5.889731,
      0,
      2.589218,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.999094,
      NULL,
      NULL,
      4,
      0.915471,
      0.096990,
      0,
      2,
      0,
      NULL,
      1,
      NULL,
      5.788621,
      4,
      0.589794,
      0,
      4,
      1.485025,
      1,
      NULL,
      0.250982,
      0,
      NULL,
      NULL,
      1,
      4.482058,
      0.989091,
      0,
      0,
      2.737524,
      0.894250,
      NULL,
      NULL,
      0.600307,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      8.119200,
      7.151318,
      5.088267,
      4,
      4.567835,
      4.901052,
      1.877162,
      9,
      NULL,
      0,
      NULL,
      NULL,
      1.672367,
      0.003307,
      4,
      1.767132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.260967,
      NULL,
      1,
      0,
      1,
      1.986392,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.712108,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.286185,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.573528,
      1.030091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697207,
      3.553032,
      0.322024,
      NULL,
      0,
      0,
      2.262077,
      0,
      1,
      2,
      3,
      1.377586,
      1.719799,
      1.919064,
      NULL,
      0,
      1,
      1.858181,
      1.818136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      '21130',
      '',
      0,
      '',
      '',
      '',
      7,
      '3002',
      '2222',
      '1422',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


