set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      '2242240',
      NULL,
      3,
      NULL,
      3,
      '201323',
      NULL,
      ' 5-19-1989',
      NULL,
      NULL,
      1,
      NULL,
      4,
      0,
      1,
      0.931676,
      1.002640,
      1.844256,
      3,
      0.722167,
      1,
      NULL,
      0,
      0.594879,
      0.108338,
      NULL,
      NULL,
      0,
      0,
      0.181092,
      0.920437,
      0,
      1,
      NULL,
      9,
      0,
      1,
      NULL,
      3.006914,
      1.588491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.972207,
      2.195617,
      1.945512,
      2.176982,
      3.924033,
      1,
      0,
      3,
      NULL,
      1.232334,
      NULL,
      2,
      1,
      1,
      3.479258,
      1.442505,
      0,
      4.909821,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1.984381,
      NULL,
      NULL,
      0.900587,
      NULL,
      NULL,
      1.660209,
      3,
      4.566066,
      NULL,
      4.546833,
      0.402501,
      NULL,
      NULL,
      0.064825,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.733373,
      NULL,
      1.424339,
      0.227828,
      NULL,
      0,
      1,
      0.850660,
      1,
      0.240165,
      0.759434,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      1.166552,
      1,
      0.646482,
      3.415067,
      NULL,
      1.349408,
      4.557079,
      2.076555,
      NULL,
      4,
      0,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0,
      1,
      1.801024,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358289,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521188,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.040098,
      5,
      0.617122,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.792466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.810682,
      1.472468,
      NULL,
      1.879651,
      3.992512,
      1,
      NULL,
      0.908433,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.357117,
      0,
      0.189051,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '23124',
      '01310',
      '',
      1,
      '',
      '',
      NULL,
      3.498235,
      '2123',
      '2122',
      '2423',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


