set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      '3204004',
      NULL,
      1,
      2.514650,
      3,
      '401144',
      0.437219,
      ' 0-29-1992',
      19,
      NULL,
      1.352467,
      NULL,
      3,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      3.357254,
      5.391971,
      NULL,
      0,
      3,
      NULL,
      0.444162,
      7.069559,
      1.686338,
      1,
      NULL,
      1.377169,
      NULL,
      9,
      0,
      4.596031,
      2,
      0.968360,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.902848,
      0.057284,
      1,
      3.280844,
      0,
      0,
      3.533793,
      0.359961,
      3.123765,
      2.916554,
      2,
      1.711824,
      0,
      1,
      1.327569,
      1.556413,
      0,
      0.389942,
      3.652377,
      0,
      0,
      6,
      6,
      1,
      1,
      3.871449,
      1,
      NULL,
      NULL,
      0.117620,
      NULL,
      NULL,
      NULL,
      5.648224,
      1,
      NULL,
      2.809994,
      3,
      0,
      0.664477,
      2,
      NULL,
      4,
      1,
      1,
      1.703063,
      1.051596,
      1,
      0,
      0,
      0.476434,
      NULL,
      0.871294,
      1,
      NULL,
      NULL,
      1,
      0.149713,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.052050,
      NULL,
      1,
      1.415368,
      3,
      0.186398,
      5,
      0,
      4,
      6,
      3.550472,
      6,
      2.030673,
      1.800132,
      NULL,
      3.757264,
      0.198708,
      0.948678,
      NULL,
      1.015526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.719596,
      NULL,
      NULL,
      NULL,
      0,
      0.772397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.369622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.788396,
      5,
      NULL,
      0,
      0.311478,
      NULL,
      NULL,
      NULL,
      NULL,
      1.070322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.260634,
      0,
      3.368692,
      NULL,
      3.269745,
      0.913939,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.473638,
      1.830097,
      0,
      1.273018,
      0.902202,
      0.935434,
      0.563658,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.010500,
      '42430',
      NULL,
      '',
      0,
      '',
      '',
      '',
      5,
      NULL,
      '4412',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


