set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '1042223',
      81.641989,
      NULL,
      1,
      2,
      NULL,
      3.117358,
      ' 5-17-1987',
      NULL,
      NULL,
      0.075809,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.338463,
      0,
      0.367794,
      2.923467,
      1.771044,
      1,
      1.908371,
      2.433180,
      NULL,
      1.727115,
      NULL,
      1,
      1,
      1.048550,
      NULL,
      1.729800,
      3.151630,
      0,
      3,
      1,
      0.700130,
      1.990184,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      1.655838,
      1.279110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      3,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.384955,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747433,
      0,
      0.821987,
      1.916742,
      5.768088,
      2.595183,
      4.151479,
      0.989228,
      0,
      0,
      0.852509,
      1,
      1.088046,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.757840,
      0.098873,
      0.569999,
      1.157473,
      NULL,
      0.898459,
      0,
      1,
      NULL,
      1.625022,
      0,
      NULL,
      NULL,
      4.915953,
      1.294913,
      0,
      2.822048,
      NULL,
      NULL,
      0.880970,
      6,
      5.450921,
      1,
      NULL,
      2.295876,
      NULL,
      NULL,
      NULL,
      0.984918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.663942,
      1,
      0,
      NULL,
      0,
      0.102248,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.405206,
      1,
      2,
      0.061390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536081,
      1.876664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.411068,
      3.295358,
      2.059253,
      NULL,
      1.534024,
      NULL,
      1.551925,
      1.352497,
      0,
      2.035324,
      NULL,
      NULL,
      1.648833,
      1.484669,
      1,
      1.045787,
      0.758409,
      0.840579,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.542490,
      '42044',
      '31343',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '2323',
      '4323',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


