set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      3,
      '224302',
      3,
      NULL,
      36,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.421401,
      2.627988,
      NULL,
      0,
      0,
      1.762404,
      0.310176,
      0.302787,
      1,
      NULL,
      4,
      0.546163,
      0.756216,
      NULL,
      1.114117,
      NULL,
      0.623571,
      1.615839,
      1.501845,
      0,
      NULL,
      1,
      NULL,
      0.321018,
      NULL,
      NULL,
      1.891077,
      NULL,
      NULL,
      9.389959,
      0.186984,
      0.961589,
      2.853319,
      1,
      0,
      0,
      0,
      NULL,
      3,
      3.594691,
      0.336120,
      0.412074,
      NULL,
      0,
      1,
      3.568607,
      NULL,
      1,
      0.765638,
      1,
      0,
      5,
      0,
      1,
      4,
      1,
      NULL,
      NULL,
      1.244342,
      NULL,
      NULL,
      1,
      2.273888,
      1.576829,
      1,
      0.516196,
      0.354648,
      1.197224,
      0.073309,
      NULL,
      0.155085,
      0.546453,
      5,
      0,
      6,
      1,
      NULL,
      1.114974,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.234785,
      1.094397,
      1.623041,
      1.678272,
      NULL,
      1.272187,
      1.943959,
      0.680426,
      1,
      0,
      1.792165,
      1.696517,
      NULL,
      NULL,
      2.621353,
      5,
      0.430552,
      2.897477,
      4,
      3,
      NULL,
      3.618146,
      4,
      0.520244,
      2,
      3,
      NULL,
      0,
      0,
      8,
      0.054294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838633,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.775335,
      1.563117,
      1,
      1.038113,
      1,
      NULL,
      NULL,
      0.733741,
      0,
      0.389812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450248,
      NULL,
      0,
      1,
      0,
      1.008092,
      0,
      NULL,
      1,
      NULL,
      2.611628,
      0.225027,
      1.737756,
      1.231815,
      1,
      0.284107,
      1.913998,
      1,
      0,
      0.361931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '01210',
      '30213',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '1333',
      '4433',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


