set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      99.744148,
      2,
      NULL,
      1,
      NULL,
      3.195578,
      ' 0-27-1994',
      29,
      NULL,
      1.913883,
      NULL,
      0,
      3.087574,
      1,
      0.813173,
      1.410971,
      NULL,
      0.664433,
      1.595714,
      1,
      1.097000,
      6.112783,
      1,
      0.868730,
      4.576659,
      0.652732,
      NULL,
      7.899788,
      1,
      0.542261,
      NULL,
      1.946930,
      0.294398,
      6.883874,
      1,
      1,
      3.843902,
      3.815501,
      1.261125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      3.741321,
      0.980423,
      1,
      2.529369,
      0.903769,
      1,
      0,
      0,
      2.609244,
      NULL,
      NULL,
      2.576220,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.981934,
      3.603118,
      NULL,
      2,
      0.708887,
      1.940897,
      NULL,
      NULL,
      0.937676,
      NULL,
      NULL,
      2,
      0.021546,
      2,
      0,
      0.587748,
      NULL,
      1,
      1.170547,
      1.088482,
      2.406466,
      2,
      1,
      1.386992,
      3,
      1.866747,
      1,
      1.386958,
      0,
      0,
      NULL,
      0,
      0.485827,
      0.014230,
      1,
      NULL,
      0,
      0.389467,
      NULL,
      0.417581,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      4,
      2.959540,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      6,
      0.439247,
      0,
      1,
      3.879689,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.881140,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3.897720,
      0,
      2,
      NULL,
      0,
      3.825618,
      1,
      1,
      5,
      0,
      2,
      NULL,
      3,
      3,
      5.312766,
      0.369692,
      NULL,
      4.250448,
      1.584875,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.826050,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.303854,
      0,
      3,
      1.388408,
      3.210866,
      3,
      0,
      1.610507,
      0.420430,
      1.587625,
      3.204458,
      1.326901,
      NULL,
      1,
      0,
      0.729105,
      0.372624,
      0.065881,
      1.973451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.645183,
      '23334',
      '34310',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '2020',
      '4241',
      '0123',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


