set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      '13',
      14,
      NULL,
      '0122214',
      77,
      NULL,
      1.895516,
      2,
      '432421',
      2,
      ' 6-17-1985',
      29,
      NULL,
      0,
      NULL,
      1.242475,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3.869672,
      NULL,
      0,
      NULL,
      1,
      1.277281,
      0,
      1.180638,
      NULL,
      NULL,
      1.857596,
      1,
      1,
      0,
      NULL,
      1.303039,
      NULL,
      0,
      NULL,
      2.387822,
      2.337242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318943,
      0,
      0.985131,
      3,
      0,
      NULL,
      3.121442,
      NULL,
      3,
      1,
      1,
      0.991119,
      0,
      2.906791,
      0.332209,
      2.964531,
      2.478452,
      0.198641,
      0.152912,
      6.148126,
      1,
      2,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      2.937982,
      1.681611,
      4,
      0,
      0,
      0,
      1,
      NULL,
      5,
      NULL,
      1,
      1,
      0.430840,
      0.312945,
      1,
      NULL,
      0,
      NULL,
      1.560879,
      1,
      1.434673,
      1.524076,
      0,
      1.347819,
      NULL,
      0.254761,
      0,
      1,
      1,
      1.300236,
      0.092276,
      0,
      NULL,
      1.349869,
      2,
      5,
      NULL,
      NULL,
      4,
      NULL,
      3.010033,
      3,
      6.187434,
      1.749773,
      0.247602,
      2.666805,
      0,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      1.980397,
      0.394876,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643133,
      NULL,
      0,
      2.418429,
      3.009198,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.767058,
      2,
      5.029182,
      1.406129,
      2,
      0.693631,
      NULL,
      NULL,
      NULL,
      1.829592,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.237234,
      0.123402,
      1,
      0,
      0,
      0.686051,
      1.313593,
      NULL,
      1.345544,
      1.460155,
      0.794383,
      0,
      0.454365,
      1,
      1,
      1.254097,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.507337,
      '14101',
      '33312',
      NULL,
      NULL,
      '',
      '',
      NULL,
      5.406191,
      NULL,
      '2410',
      '',
      3.727080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


