set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '234',
      NULL,
      8,
      22.544229,
      '2002330',
      87.342094,
      3,
      2,
      NULL,
      '204140',
      5.929927,
      ' 4-11-1978',
      7,
      65.361734,
      NULL,
      NULL,
      0,
      1,
      1.600508,
      1,
      1,
      0.173276,
      0,
      1,
      1.154860,
      NULL,
      NULL,
      0.191616,
      NULL,
      0,
      3,
      0,
      NULL,
      0,
      1,
      0.212155,
      1,
      1.614407,
      6,
      1,
      2,
      0.982800,
      0.622245,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.632201,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.773054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.661292,
      5,
      0.172533,
      0,
      0.781954,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0.950685,
      1.691919,
      0,
      NULL,
      1,
      0.011244,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.705954,
      4,
      NULL,
      0.429377,
      0,
      1.874087,
      1,
      0.325146,
      0,
      NULL,
      1.306312,
      3.014313,
      1.739401,
      4,
      1,
      1.026923,
      4.717338,
      6,
      1,
      1.950905,
      1.629903,
      1,
      0,
      1,
      3.512551,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.268639,
      0,
      0,
      0,
      0.474991,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.161874,
      NULL,
      2.754446,
      3,
      0.784282,
      1,
      1,
      0.932630,
      1.580130,
      0,
      2,
      0,
      0.261299,
      1,
      0.362662,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7.590773,
      3.587048,
      0,
      1,
      NULL,
      0.423489,
      0,
      NULL,
      14,
      3.606376,
      2,
      4,
      3,
      4.339163,
      0.154716,
      0.044440,
      1,
      NULL,
      0.057664,
      1,
      1.485625,
      NULL,
      1,
      3,
      1.162098,
      2.062555,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1.136228,
      NULL,
      0,
      0,
      1.900387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      '23341',
      0.873149,
      '',
      '',
      '',
      NULL,
      '1112',
      '0214',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


