set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '100',
      NULL,
      4.130593,
      NULL,
      '3222010',
      19,
      NULL,
      0,
      2,
      '303104',
      4.352143,
      ' 5-13-1975',
      20,
      130,
      0,
      NULL,
      11,
      2.217397,
      1.642684,
      1,
      0.080569,
      3.923675,
      NULL,
      1.391476,
      2.200319,
      1,
      1.933371,
      0,
      NULL,
      9,
      3.676409,
      3.237985,
      5.237406,
      0.812616,
      3,
      0.167411,
      7,
      0,
      1.070218,
      1,
      3.531516,
      1.115371,
      3.288388,
      1.452934,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.844887,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.820470,
      1,
      6,
      7.816538,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      1.568240,
      NULL,
      NULL,
      1.681743,
      3,
      NULL,
      0.428212,
      NULL,
      0,
      NULL,
      0.895513,
      NULL,
      2,
      2,
      1,
      0,
      4.773697,
      1,
      0.769814,
      1.496994,
      0,
      0.899975,
      NULL,
      0,
      1.136846,
      0.787577,
      0,
      NULL,
      1.003224,
      1,
      1.331038,
      NULL,
      0,
      NULL,
      0.988609,
      1,
      0,
      0.082359,
      1.395012,
      NULL,
      5,
      NULL,
      9.080246,
      6,
      0,
      NULL,
      NULL,
      8.863048,
      1.099845,
      0.760956,
      0.686168,
      3,
      0,
      NULL,
      0.186783,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.967822,
      2.461430,
      1.777732,
      0.528778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.501083,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.261543,
      0.855152,
      7.448514,
      NULL,
      3.340366,
      1,
      0.678663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.228898,
      0.954305,
      2.632808,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0.007553,
      1.131163,
      0.482384,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '41002',
      NULL,
      '',
      1,
      '',
      '',
      '',
      3,
      '0121',
      NULL,
      '',
      0.343556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


