set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '241',
      '03',
      2.662401,
      10.727196,
      '3224441',
      63.266316,
      NULL,
      0,
      NULL,
      '301010',
      4.776757,
      ' 4- 4-1998',
      2.348719,
      61,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1.835700,
      3,
      1,
      1.189206,
      0,
      0.214088,
      9,
      1,
      0.887720,
      7,
      0.646227,
      NULL,
      4.654930,
      1,
      1,
      0,
      11,
      1,
      9,
      1,
      NULL,
      0.233978,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      3,
      0.636261,
      1.891401,
      1.584009,
      0.860991,
      1,
      1,
      1,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1.977232,
      0.816272,
      2,
      0,
      NULL,
      NULL,
      0,
      4.597976,
      1,
      NULL,
      NULL,
      0.427744,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5.409018,
      1.575282,
      NULL,
      1,
      1.890261,
      0,
      1,
      1,
      1,
      0.029757,
      NULL,
      0,
      NULL,
      1,
      0.208605,
      1,
      0.667162,
      1,
      NULL,
      NULL,
      1,
      0,
      0.502733,
      0.972468,
      NULL,
      NULL,
      0.967284,
      NULL,
      1,
      NULL,
      1.407333,
      0.708883,
      0,
      1,
      NULL,
      5.365338,
      4.795654,
      7,
      NULL,
      NULL,
      NULL,
      0.718751,
      0,
      9,
      3.125038,
      1.849383,
      2,
      2.090509,
      NULL,
      1,
      1.527738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.974225,
      0,
      NULL,
      0,
      1,
      0,
      1.486164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.595046,
      3,
      0.694270,
      NULL,
      NULL,
      NULL,
      0.321797,
      NULL,
      2.952581,
      2.575766,
      3.387462,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.784293,
      0,
      3.438574,
      1.038349,
      0.866833,
      NULL,
      1.950197,
      NULL,
      1.769563,
      1.642677,
      1,
      1,
      0.681064,
      NULL,
      1,
      NULL,
      0.419338,
      NULL,
      1.382657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '12122',
      '14004',
      '',
      1.826850,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


