set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '430',
      '33',
      11.542039,
      NULL,
      '2002031',
      NULL,
      6,
      3,
      1,
      NULL,
      5.995493,
      NULL,
      11.482822,
      99,
      1,
      NULL,
      0.114621,
      0,
      0.695044,
      0,
      1,
      NULL,
      3,
      NULL,
      0.567236,
      NULL,
      9,
      NULL,
      0.292472,
      6.776916,
      2.571225,
      1.349814,
      NULL,
      0.296731,
      1,
      1.686336,
      2,
      NULL,
      NULL,
      0,
      0.089166,
      3,
      NULL,
      0.394801,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.900540,
      0.540317,
      2.909125,
      1.965165,
      0.610763,
      0,
      NULL,
      NULL,
      0.911683,
      1.249341,
      0,
      NULL,
      0,
      3,
      NULL,
      2,
      1,
      NULL,
      1,
      2.061334,
      6,
      7.546197,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.896723,
      NULL,
      NULL,
      0.794893,
      NULL,
      NULL,
      1.405107,
      5.421758,
      0,
      4.046473,
      NULL,
      0,
      1,
      3,
      0.104840,
      0,
      2.894848,
      1,
      0.342083,
      0.881629,
      1.118317,
      0.029595,
      NULL,
      0.048313,
      1,
      0.879295,
      0.512959,
      NULL,
      0,
      0,
      0.838433,
      1,
      NULL,
      1.258337,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      1.338521,
      0.560594,
      6,
      4,
      2,
      9,
      9,
      0.181089,
      0.207849,
      0.868552,
      3,
      NULL,
      1,
      0.920331,
      0,
      0.553125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.876377,
      0.595887,
      4.748552,
      NULL,
      0,
      1.624922,
      NULL,
      NULL,
      NULL,
      1,
      0.487559,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3,
      0.420492,
      3.268721,
      0.384442,
      NULL,
      1.144108,
      1,
      1.962678,
      NULL,
      0.324225,
      1.370285,
      0,
      1.389420,
      NULL,
      1.918810,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      '40334',
      '34341',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


