set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '44',
      NULL,
      24.902733,
      '0302041',
      138,
      6,
      3.881084,
      1,
      '423231',
      0,
      ' 4-28-1984',
      NULL,
      7.190792,
      1.679570,
      NULL,
      0.705542,
      1,
      1,
      0.326592,
      0,
      1,
      2.707528,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1.237328,
      2,
      NULL,
      5,
      0.887735,
      NULL,
      0.677147,
      NULL,
      2.390942,
      NULL,
      0,
      5.313255,
      NULL,
      5,
      0.351320,
      NULL,
      NULL,
      1.526188,
      NULL,
      NULL,
      6,
      3,
      1.496331,
      NULL,
      0,
      1.486268,
      NULL,
      1.400921,
      NULL,
      NULL,
      0.999166,
      NULL,
      0.213460,
      0,
      1,
      NULL,
      NULL,
      1.199881,
      NULL,
      4.497132,
      NULL,
      0.238298,
      7,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.111490,
      NULL,
      NULL,
      NULL,
      0.346285,
      0,
      0.169657,
      1.346136,
      1.328353,
      1,
      1.917653,
      1.960058,
      NULL,
      3.178308,
      1,
      NULL,
      1,
      0,
      NULL,
      1.898158,
      NULL,
      1.395284,
      NULL,
      1,
      0,
      NULL,
      0.630146,
      0.108186,
      0.792792,
      0.275805,
      0,
      NULL,
      0.374240,
      NULL,
      0,
      0,
      NULL,
      1.479416,
      NULL,
      NULL,
      1.041202,
      1.940312,
      0,
      4,
      NULL,
      8.064276,
      11.919862,
      1.134662,
      1,
      0,
      3,
      0,
      NULL,
      1.975521,
      1.481497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864547,
      1,
      0,
      NULL,
      1,
      NULL,
      0.469700,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.404538,
      NULL,
      NULL,
      2.306355,
      NULL,
      3.539161,
      NULL,
      1.833536,
      0.035551,
      1,
      2.982529,
      NULL,
      1.117049,
      1.206655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685548,
      1,
      NULL,
      3,
      1.212244,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456826,
      3.465433,
      0.030842,
      NULL,
      NULL,
      0.939596,
      3.349865,
      0,
      1,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      1.017989,
      0.402903,
      NULL,
      0,
      1.049394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.480919,
      '40412',
      '32113',
      '',
      1,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      0.677079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


