set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '340',
      '40',
      42.998842,
      NULL,
      '0230143',
      193.890427,
      1,
      1.457089,
      0,
      '041011',
      NULL,
      ' 2-16-1975',
      3.943434,
      53.477977,
      NULL,
      NULL,
      1,
      3,
      1,
      0.663841,
      0,
      1,
      NULL,
      1.883929,
      0.281559,
      2,
      1.529884,
      0,
      NULL,
      4.842298,
      1.541797,
      2,
      6,
      1,
      0,
      NULL,
      2.902971,
      2.741410,
      0,
      0,
      3.290665,
      0,
      1,
      1.620614,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.932545,
      1,
      1.288602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.925918,
      3,
      4,
      0,
      1,
      0.431143,
      1.253884,
      NULL,
      NULL,
      0.446279,
      NULL,
      NULL,
      0,
      NULL,
      5,
      1.585616,
      4.866565,
      4,
      4.077231,
      0.168973,
      0,
      3,
      NULL,
      0,
      1.345056,
      4,
      1.617578,
      0,
      0,
      1,
      0.645034,
      NULL,
      0.533635,
      0,
      NULL,
      1.229200,
      NULL,
      NULL,
      NULL,
      0.177087,
      NULL,
      1,
      NULL,
      NULL,
      1.968644,
      NULL,
      0,
      1.532613,
      2.112904,
      1,
      3.441540,
      4,
      3.466388,
      4.486828,
      2,
      6.674573,
      2,
      3.820271,
      NULL,
      2,
      3,
      NULL,
      1,
      1.788964,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1.068248,
      0,
      0.178158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158074,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.967778,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      5.451449,
      1.713028,
      0,
      5,
      1,
      NULL,
      NULL,
      1.969156,
      NULL,
      1.275675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2,
      0,
      1,
      2.573943,
      NULL,
      NULL,
      1,
      1.328626,
      3,
      0,
      NULL,
      0,
      0.615690,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.831074,
      '42224',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      2.600282,
      3,
      3.067700,
      2.401631,
      1.389610,
      2,
      NULL,
      1.937106);
commit;
end;
/


