set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03230313',
      24.898936,
      39,
      '3144030',
      31.459231,
      2,
      2,
      NULL,
      NULL,
      4,
      ' 0- 8-2002',
      6.167490,
      NULL,
      0.571753,
      NULL,
      1,
      NULL,
      0.811866,
      1,
      1,
      0.037586,
      3,
      1,
      0.421791,
      0,
      4,
      1.563069,
      1,
      5,
      7.539198,
      3,
      4.084447,
      1,
      0.802091,
      NULL,
      2,
      1,
      9,
      0,
      1.152453,
      1.560468,
      1.218343,
      1,
      NULL,
      NULL,
      1.483593,
      NULL,
      NULL,
      2.231808,
      0.224735,
      0,
      0.667245,
      1.065031,
      1.222880,
      3,
      1.656506,
      0,
      3.628254,
      3,
      2,
      NULL,
      3,
      1,
      NULL,
      1,
      0,
      2.654556,
      2,
      0.058394,
      NULL,
      3,
      NULL,
      1,
      3.331781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306348,
      4,
      NULL,
      0,
      4,
      NULL,
      0.023791,
      1,
      0,
      3.605346,
      1.893132,
      3,
      0.292237,
      3.140939,
      NULL,
      1.527643,
      1.568387,
      0,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1.440873,
      0,
      1.347917,
      NULL,
      1,
      0.510600,
      1,
      NULL,
      0,
      0.055605,
      0.625541,
      0,
      6,
      NULL,
      0,
      3,
      5.285503,
      2.168733,
      0,
      NULL,
      0,
      0.558435,
      1.152988,
      2,
      NULL,
      NULL,
      1.288094,
      1.223099,
      0.587773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.130362,
      1,
      0,
      0.978513,
      1,
      1.200412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.317050,
      NULL,
      5,
      3.308789,
      3,
      1.287232,
      NULL,
      3.070283,
      NULL,
      1.420183,
      3,
      NULL,
      1.109716,
      1.960314,
      NULL,
      2,
      0,
      0,
      0.931142,
      NULL,
      5,
      NULL,
      2,
      0.104984,
      NULL,
      NULL,
      NULL,
      NULL,
      1.633755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.955332,
      2,
      2.423852,
      3.569298,
      NULL,
      1.869661,
      1,
      0,
      NULL,
      0.046164,
      2.345546,
      NULL,
      0,
      0.213020,
      1.104593,
      0.760565,
      NULL,
      0.691469,
      0,
      0.187621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '44201',
      '22311',
      '',
      0.487176,
      '',
      '',
      '',
      0.719999,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      1.035007,
      2.299830,
      2,
      0.481051,
      1,
      NULL);
commit;
end;
/


