set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '101',
      '44214403',
      16.601979,
      5.398239,
      '3043434',
      35,
      1,
      1,
      1,
      NULL,
      4,
      ' 5-10-1979',
      NULL,
      54,
      1.896349,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1.703810,
      0.949702,
      0.963463,
      NULL,
      NULL,
      1,
      2,
      3.804458,
      NULL,
      5,
      0.170237,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      2.010965,
      2.284012,
      1.773839,
      1.076177,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.875458,
      NULL,
      0,
      2,
      3,
      3.285571,
      NULL,
      2,
      2.456086,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0.387274,
      NULL,
      6.094370,
      1,
      1.386296,
      6.837659,
      0,
      1,
      0.475878,
      1.207562,
      NULL,
      NULL,
      0.577359,
      NULL,
      NULL,
      0,
      0,
      0.116025,
      1.857665,
      1,
      0.974854,
      NULL,
      1.921825,
      1,
      0.623526,
      0.656608,
      5.073499,
      1.903476,
      4.001523,
      0,
      1,
      NULL,
      0,
      0.392671,
      NULL,
      1.844433,
      NULL,
      0,
      0.943465,
      1,
      0,
      1.747792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100023,
      1.296103,
      1.938561,
      0,
      2,
      4.330516,
      5,
      2,
      1.392853,
      4.117394,
      2.243039,
      6.782294,
      3.615223,
      NULL,
      0.551038,
      1,
      0.137304,
      0.688341,
      1.255385,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.829764,
      1,
      1,
      NULL,
      0.389678,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.958275,
      NULL,
      7.141714,
      3.648393,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.183023,
      1.885506,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1.765624,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.270667,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.323212,
      0.881157,
      1,
      NULL,
      3.093675,
      NULL,
      1,
      1,
      NULL,
      0.235496,
      0,
      0.921418,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0.274661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.496323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '21214',
      '',
      0.534587,
      '',
      '',
      '',
      1.107257,
      '',
      '',
      '',
      2,
      1,
      1.761247,
      0.747647,
      0,
      1,
      2.841331,
      NULL,
      1);
commit;
end;
/


