set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '401',
      '00024234',
      NULL,
      NULL,
      '4232434',
      87.548227,
      4,
      1,
      2,
      '321023',
      2,
      ' 6-24-1975',
      41.585250,
      25.896495,
      NULL,
      NULL,
      0.731177,
      1,
      3.550843,
      1.918352,
      NULL,
      NULL,
      0.080935,
      NULL,
      NULL,
      1.110004,
      6,
      1,
      1.472639,
      NULL,
      3.291987,
      2,
      NULL,
      1,
      1.860680,
      0,
      0.307012,
      0.433897,
      3.005072,
      1,
      3,
      1.349192,
      3,
      1.748275,
      NULL,
      NULL,
      0.586033,
      NULL,
      NULL,
      3.285215,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.485969,
      1,
      NULL,
      NULL,
      1.692488,
      NULL,
      NULL,
      NULL,
      0.565824,
      0.506215,
      0.600915,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.985631,
      NULL,
      1,
      1,
      1.953052,
      1,
      0.525058,
      NULL,
      1.403769,
      0.918020,
      1,
      1.602745,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.176069,
      5,
      2.841100,
      0,
      6,
      7.494131,
      1.280180,
      6,
      7.707999,
      1.613710,
      2,
      4,
      3,
      0.372929,
      1.613552,
      0,
      1.001541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661374,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0.618679,
      2.284747,
      3.569130,
      NULL,
      1,
      0.701199,
      1,
      2,
      NULL,
      0,
      2,
      0.845362,
      4,
      2.860852,
      1.534737,
      NULL,
      1.918923,
      NULL,
      NULL,
      NULL,
      0.643883,
      0.465558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750787,
      2,
      0,
      3,
      2.410372,
      NULL,
      3,
      1,
      1,
      2.386967,
      2.151845,
      NULL,
      0.830504,
      0.523630,
      0.503630,
      1.943881,
      0.507570,
      0,
      1.629117,
      1.750862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.842610,
      '34002',
      '03302',
      '',
      0.278623,
      NULL,
      '',
      NULL,
      0.199848,
      '',
      '',
      '',
      5.138357,
      3,
      NULL,
      1,
      1,
      2.262396,
      NULL,
      0.869059,
      0);
commit;
end;
/


