set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '423',
      '42304341',
      10,
      75.402439,
      '4344104',
      202,
      1,
      0.669818,
      1,
      '202231',
      0,
      ' 8-16-1975',
      NULL,
      NULL,
      0.247804,
      NULL,
      1.446545,
      1.956558,
      2.873473,
      0.929991,
      NULL,
      1,
      NULL,
      0.523461,
      1,
      NULL,
      7,
      0.922715,
      1,
      2,
      3.501335,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      4,
      0,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.001861,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.246750,
      NULL,
      0.600094,
      NULL,
      1,
      0,
      1.889068,
      1.265976,
      NULL,
      NULL,
      1.452476,
      NULL,
      NULL,
      1.279342,
      NULL,
      0,
      0.670707,
      1.649077,
      5.792903,
      0,
      NULL,
      NULL,
      0.140564,
      NULL,
      1.642049,
      0,
      3,
      NULL,
      1.442430,
      0,
      1.740082,
      0,
      NULL,
      0.254553,
      0.441694,
      0.791357,
      0,
      1,
      1.134646,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.809268,
      0.970642,
      0,
      5.511787,
      3,
      5.495787,
      NULL,
      4,
      NULL,
      1.781367,
      1,
      1.646881,
      4.610842,
      1,
      5.650087,
      0,
      0.608488,
      0,
      2,
      1.440054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360573,
      1.323995,
      1,
      NULL,
      1.082117,
      0.360759,
      0.744678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.125845,
      2.071888,
      NULL,
      3.924252,
      0,
      NULL,
      NULL,
      NULL,
      1.566528,
      0.226733,
      1,
      1.770419,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.531313,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.007636,
      2.594706,
      NULL,
      NULL,
      0,
      0.369605,
      0,
      3,
      2,
      1,
      NULL,
      1.199491,
      1,
      NULL,
      0.313018,
      1.305592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '40142',
      '33310',
      '',
      0.784277,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      1,
      NULL,
      NULL,
      0.150065,
      2,
      7,
      0.972749,
      NULL);
commit;
end;
/


