set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24344310',
      48,
      NULL,
      '4233201',
      182,
      NULL,
      0,
      1,
      NULL,
      0.692566,
      '11- 5-1985',
      11.792224,
      27.137410,
      1,
      NULL,
      NULL,
      0,
      0.307848,
      0,
      0,
      0,
      1.903257,
      0.683834,
      NULL,
      0,
      5.424289,
      1,
      0.394401,
      11.799018,
      5.469361,
      2,
      NULL,
      1.582350,
      2,
      1,
      3.279662,
      0.144176,
      8,
      1,
      0.565269,
      2.261746,
      4,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.750842,
      5.647219,
      NULL,
      0,
      0,
      0,
      1,
      1.092414,
      0.748044,
      0.359248,
      3,
      NULL,
      1.432635,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.099867,
      4,
      3.519749,
      1.841791,
      5.046765,
      1,
      1,
      NULL,
      1.233531,
      NULL,
      NULL,
      1.366760,
      NULL,
      NULL,
      NULL,
      NULL,
      3.183137,
      0.294292,
      0,
      NULL,
      1.042843,
      1.413761,
      0.456896,
      1,
      3,
      NULL,
      NULL,
      5.435355,
      NULL,
      NULL,
      0.604463,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.948784,
      NULL,
      NULL,
      0,
      NULL,
      2.773134,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      5,
      1,
      NULL,
      1.787450,
      6,
      NULL,
      2.589589,
      7,
      7,
      NULL,
      7,
      5,
      2,
      NULL,
      3,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1.580904,
      1.808031,
      1,
      0.770129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363190,
      NULL,
      NULL,
      NULL,
      NULL,
      0.225494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.147943,
      1,
      1,
      0.655307,
      2,
      4,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693783,
      NULL,
      NULL,
      3.417962,
      2.877815,
      NULL,
      0,
      0.267195,
      1,
      2,
      3,
      0.092098,
      0.367458,
      NULL,
      NULL,
      0.146637,
      0,
      0,
      0.036656,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '33011',
      '',
      1,
      '',
      '',
      '',
      1.025680,
      '',
      '',
      NULL,
      NULL,
      1,
      3.079704,
      3.302824,
      NULL,
      NULL,
      NULL,
      2,
      NULL);
commit;
end;
/


