set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      '44401012',
      52.953310,
      64,
      NULL,
      273,
      6,
      1,
      0,
      '003212',
      2.362680,
      ' 4-15-1975',
      7,
      NULL,
      1.293882,
      NULL,
      1,
      0,
      1,
      0.052895,
      NULL,
      0,
      1,
      NULL,
      1.473537,
      NULL,
      0,
      0.455362,
      0.138985,
      6.622929,
      0,
      3,
      6,
      1.006299,
      1.335139,
      1.279339,
      NULL,
      1.565618,
      4.093207,
      1,
      5,
      3.199712,
      5,
      0.741012,
      NULL,
      NULL,
      0.897829,
      NULL,
      NULL,
      0.521700,
      3,
      0,
      0.103469,
      NULL,
      0.509662,
      2.363085,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      2,
      0,
      0.425550,
      3.924420,
      NULL,
      NULL,
      1,
      0,
      0,
      6.064040,
      0,
      1,
      NULL,
      0.909104,
      NULL,
      NULL,
      0.109313,
      NULL,
      NULL,
      0.849830,
      2,
      1,
      2.193231,
      2,
      3,
      0,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0.909119,
      1,
      NULL,
      0,
      0.292931,
      1.678466,
      NULL,
      0,
      NULL,
      1.793005,
      NULL,
      0.654201,
      2,
      2.452721,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4.671966,
      0.383745,
      3,
      0,
      3,
      6,
      NULL,
      2,
      6.556906,
      0.560838,
      7,
      7,
      NULL,
      1.144601,
      0,
      3,
      3,
      1.298973,
      NULL,
      1.638180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.212841,
      1,
      NULL,
      0,
      1,
      1.028115,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.527940,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.631594,
      NULL,
      1,
      NULL,
      1,
      3.948950,
      1,
      0,
      1.206512,
      NULL,
      0.066518,
      2,
      4,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.482304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294131,
      0.334517,
      0.257448,
      3.465861,
      0,
      1.961326,
      0.638542,
      3,
      NULL,
      0,
      1.254607,
      1.718301,
      1.135029,
      0.851749,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.608946,
      '14121',
      '21433',
      '',
      1.166054,
      '',
      '',
      '',
      0.701580,
      NULL,
      '',
      '',
      3.442596,
      NULL,
      1,
      1,
      2.721450,
      2,
      3,
      2,
      0);
commit;
end;
/


