set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4312',
      '14444403',
      NULL,
      54.870870,
      '2220044',
      110.588930,
      0,
      0,
      1,
      '013022',
      0.141110,
      ' 5- 3-2003',
      13.246380,
      23.112850,
      NULL,
      NULL,
      NULL,
      1.263983,
      1.189448,
      0.901666,
      1,
      NULL,
      1.356214,
      NULL,
      NULL,
      0.479312,
      5.881480,
      0.589566,
      0,
      2.118618,
      5.571160,
      1,
      NULL,
      0,
      NULL,
      1,
      1.500446,
      1.738534,
      0.994592,
      1,
      2,
      NULL,
      NULL,
      0.785639,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.831477,
      4,
      0.782476,
      0,
      1.155150,
      1.392876,
      0,
      0.205143,
      0,
      2.899018,
      3,
      0.522157,
      NULL,
      1.032847,
      1.676346,
      1,
      0,
      0.236156,
      0,
      1.925093,
      0.977047,
      0,
      1.759799,
      0,
      1,
      NULL,
      1.301208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635798,
      4.537664,
      NULL,
      0.944878,
      NULL,
      5.004921,
      3.670967,
      1,
      0.945376,
      1,
      1.285609,
      NULL,
      1.614880,
      2.817591,
      0,
      1.680476,
      1.218313,
      0.242317,
      0,
      NULL,
      1,
      0.951483,
      NULL,
      1,
      1.804359,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.728710,
      1,
      3,
      0,
      3.657110,
      6.768642,
      1.603505,
      2,
      0.576834,
      5,
      NULL,
      NULL,
      3.502620,
      0,
      4.238160,
      1,
      3.533243,
      1.762273,
      0.225859,
      2.062391,
      1.471617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1.567637,
      1.787392,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      0.256760,
      0.728769,
      5.024334,
      6,
      2.852420,
      0,
      NULL,
      NULL,
      NULL,
      5.799660,
      1,
      0,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5.014618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816523,
      2,
      2.895985,
      3.026176,
      3.419722,
      0.147514,
      3.747418,
      3.248435,
      0.330507,
      2.115347,
      0,
      1.707507,
      0.455315,
      NULL,
      1.480278,
      1.727144,
      0.340589,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '03132',
      '34204',
      '',
      1,
      '',
      '',
      '',
      1.512086,
      '',
      '',
      NULL,
      1,
      2,
      1.923980,
      0,
      3.671566,
      0.783230,
      NULL,
      2.879059,
      NULL);
commit;
end;
/


