set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4224',
      '14211311',
      82.936656,
      NULL,
      '0110133',
      77,
      3,
      3.611801,
      3,
      '204044',
      0.421236,
      NULL,
      8.798995,
      64,
      1.156742,
      NULL,
      0.040844,
      1,
      1,
      1.799701,
      1.091875,
      1.458578,
      1.139888,
      0.061303,
      NULL,
      0,
      8,
      0,
      NULL,
      1.734145,
      3,
      2.986638,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      3.098326,
      1,
      3.481881,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.427655,
      NULL,
      NULL,
      0.092194,
      1,
      0,
      0,
      0.081535,
      1.123533,
      1.178343,
      1.609902,
      1,
      3,
      3,
      1.105406,
      0.172966,
      0.260161,
      3,
      0.625116,
      NULL,
      0,
      1,
      4,
      1,
      7.045236,
      NULL,
      0,
      0,
      2,
      0.771758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108185,
      0.099084,
      NULL,
      2.591579,
      2.464448,
      5.337471,
      0.515344,
      0,
      1.263187,
      1,
      3.547688,
      4,
      1.430320,
      2,
      1.723841,
      0.904074,
      1.269327,
      0.800166,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.154444,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      8,
      7.651374,
      1.303980,
      0,
      5,
      1.152099,
      1,
      0,
      0,
      1.232537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.622143,
      1.288227,
      0,
      1,
      1.824799,
      1,
      1.684693,
      1.363750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883262,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5.236300,
      3.173716,
      0,
      0,
      4,
      1,
      NULL,
      NULL,
      1.764124,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.790065,
      1,
      NULL,
      0.189268,
      3,
      2.214805,
      NULL,
      2.479820,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      1.711611,
      NULL,
      1,
      0.745565,
      1,
      1.602274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.582301,
      '21300',
      '32214',
      NULL,
      1.638819,
      '',
      NULL,
      '',
      3.044879,
      '3110',
      '',
      NULL,
      3,
      0.495620,
      3,
      0.686834,
      2,
      1.854208,
      1,
      0,
      NULL);
commit;
end;
/


