set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2434',
      '21214234',
      97,
      NULL,
      '2024344',
      225,
      6,
      0,
      0,
      '412020',
      NULL,
      ' 8-13-1991',
      31,
      0.656939,
      0,
      NULL,
      0,
      0.872601,
      0.258379,
      0.659205,
      1.082501,
      0,
      NULL,
      NULL,
      1,
      NULL,
      5.830659,
      NULL,
      0,
      0,
      NULL,
      1,
      5,
      1,
      0,
      0.190032,
      NULL,
      0,
      5.423682,
      0,
      1.655903,
      NULL,
      1,
      1.373389,
      NULL,
      NULL,
      1.245199,
      NULL,
      NULL,
      NULL,
      1.702452,
      1.009669,
      1,
      1,
      1.523510,
      3,
      3.761244,
      3.587122,
      0,
      NULL,
      2,
      1,
      2,
      0,
      1.606773,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.542136,
      2.130849,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.433948,
      5.493337,
      0.012123,
      0,
      5,
      3.701939,
      1.650415,
      3,
      NULL,
      1.788639,
      0,
      1,
      NULL,
      NULL,
      0.531420,
      1.473193,
      0.088510,
      1.139623,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      2.487059,
      NULL,
      1.645746,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.318497,
      NULL,
      0,
      1,
      2,
      8,
      9.934535,
      8.739576,
      NULL,
      NULL,
      6,
      5,
      4,
      2,
      1,
      3,
      0,
      0.017913,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744577,
      0,
      1,
      NULL,
      1.862100,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.651975,
      0.195979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3.576363,
      NULL,
      NULL,
      NULL,
      0.609031,
      3.551198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.505943,
      1,
      1.752429,
      0,
      2,
      2.005631,
      0,
      NULL,
      0,
      3.320722,
      3.749937,
      0,
      0,
      1,
      1,
      1.957604,
      1,
      NULL,
      0.991990,
      0.099247,
      0.430676,
      1.573709,
      1.218202,
      0,
      1,
      1.923116,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.723992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.378025,
      NULL,
      '33311',
      '',
      0,
      NULL,
      '',
      NULL,
      4,
      NULL,
      '3214',
      NULL,
      4.327603,
      NULL,
      1.025270,
      NULL,
      NULL,
      2.321190,
      0.527947,
      3,
      6.156888);
commit;
end;
/


