set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9784714';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21114430',
      34,
      3.236103,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '100241',
      1.341654,
      '11-21-1984',
      144,
      NULL,
      0,
      NULL,
      NULL,
      0.474449,
      NULL,
      0,
      0,
      NULL,
      1.992481,
      3.539115,
      NULL,
      0,
      3,
      NULL,
      0.680490,
      1.124639,
      1,
      1.546922,
      NULL,
      1,
      1,
      NULL,
      1,
      1.067443,
      3.426237,
      1,
      NULL,
      0.684225,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.664012,
      0.576141,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.726452,
      0,
      0.018188,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.577358,
      1,
      0.425104,
      NULL,
      1,
      1.393945,
      1,
      NULL,
      NULL,
      NULL,
      0.386050,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0.045239,
      6.096715,
      0,
      2,
      0.466184,
      NULL,
      0,
      NULL,
      4,
      1,
      NULL,
      1,
      0.504142,
      4,
      NULL,
      NULL,
      6.701936,
      6,
      NULL,
      3.581119,
      2.379690,
      6,
      7.555809,
      3,
      1,
      NULL,
      1.879332,
      0,
      NULL,
      NULL,
      0.104207,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.555594,
      1,
      0,
      1.180674,
      0.227286,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.459573,
      0,
      1.258624,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.026183,
      1.077995,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.817722,
      NULL,
      0.855209,
      0.915237,
      1.087876,
      1,
      2.044881,
      NULL,
      NULL,
      2,
      1,
      3,
      1.532223,
      2,
      0,
      0,
      1,
      1,
      2.903020,
      NULL,
      0.143319,
      0.931558,
      2.447583,
      1.593938,
      1,
      0.680138,
      1,
      1.366146,
      0.004722,
      1,
      NULL,
      0.032885,
      1,
      0.508634,
      0,
      NULL,
      0,
      1.169361,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '33320',
      NULL,
      '',
      1,
      '',
      NULL,
      NULL,
      0,
      '',
      NULL,
      NULL,
      4.587996,
      NULL,
      4,
      2,
      1,
      1,
      2.556458,
      3.008963,
      0.034416);
commit;
end;
/


