set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9784714';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '112',
      '23413003',
      43,
      35.049353,
      NULL,
      8,
      2,
      0,
      NULL,
      '304234',
      0.366450,
      NULL,
      192,
      13,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1.645506,
      0.068006,
      3,
      0,
      2.687586,
      NULL,
      0.859597,
      NULL,
      1.505723,
      0,
      0.088603,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.460243,
      NULL,
      0,
      1.585674,
      1.353664,
      1.341702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.920906,
      0,
      0.949973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.498729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420891,
      1,
      1.961978,
      1,
      1,
      5.770538,
      0,
      1.236810,
      NULL,
      NULL,
      0.266378,
      0.879496,
      1.929390,
      1,
      0.995517,
      0.338078,
      0,
      0,
      1.815709,
      NULL,
      NULL,
      5.103799,
      1.154068,
      0.858403,
      4.112704,
      1.413623,
      5,
      0.049442,
      7.052297,
      3.645187,
      0.902495,
      2,
      0.183956,
      5,
      7,
      NULL,
      NULL,
      NULL,
      7.017899,
      7,
      NULL,
      0.634471,
      2.857125,
      7,
      4.548694,
      2.471038,
      1.435773,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.547230,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.008252,
      3,
      6,
      3,
      3,
      1,
      1,
      3.071803,
      5,
      3.705299,
      0.625068,
      NULL,
      NULL,
      NULL,
      1.015118,
      4,
      0,
      9,
      6,
      0,
      1.278198,
      NULL,
      NULL,
      NULL,
      1.599405,
      NULL,
      0.719560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202350,
      NULL,
      2.862506,
      0.370202,
      0.496259,
      2.748665,
      3.282901,
      2,
      0,
      3.505177,
      0.497031,
      1,
      3,
      1.442705,
      1.780450,
      1,
      1,
      0.995065,
      0,
      0.806231,
      1.684431,
      1,
      0.810929,
      0,
      NULL,
      3,
      1.473404,
      0,
      0,
      1,
      1.334396,
      1.468104,
      0,
      1.829458,
      1.095861,
      NULL,
      0,
      0,
      1.609577,
      1.757547,
      1,
      NULL,
      0.425486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '03034',
      '24020',
      '',
      1.695247,
      '',
      '',
      '',
      0.040105,
      NULL,
      '',
      '',
      2.985489,
      1.024914,
      1.469421,
      NULL,
      1.232889,
      3,
      3.182425,
      0.001248,
      NULL);
commit;
end;
/


