set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6905583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '444',
      NULL,
      56,
      NULL,
      '3104313',
      129.101981,
      NULL,
      0,
      2,
      '332222',
      5,
      ' 6-10-1997',
      53,
      NULL,
      0.809830,
      NULL,
      1,
      3,
      1.736881,
      1,
      0,
      0.790316,
      NULL,
      1,
      1.707780,
      0,
      0,
      0.101619,
      0,
      1.305295,
      1.554893,
      0,
      0.579756,
      1.958855,
      1.976183,
      0.630021,
      1.495754,
      1.628429,
      1.693963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.671308,
      1,
      0,
      1.626693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.216302,
      0,
      0,
      0.658355,
      0.072189,
      1,
      1.019760,
      0,
      0,
      0,
      0.793893,
      NULL,
      1.736671,
      NULL,
      1.542048,
      1.465603,
      NULL,
      1,
      2.849727,
      1.689232,
      1.574223,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      3,
      1.767893,
      1,
      NULL,
      2,
      1.172720,
      1.078161,
      3,
      0,
      NULL,
      3,
      NULL,
      NULL,
      7,
      7.580803,
      1.167061,
      2.584629,
      2.589976,
      0.660579,
      NULL,
      NULL,
      8,
      1.248913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.001027,
      1,
      0,
      0,
      NULL,
      1,
      1.620478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.494027,
      NULL,
      1.253379,
      2.993465,
      0,
      1.502893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1,
      1,
      0,
      5.754263,
      NULL,
      NULL,
      NULL,
      2,
      5.676085,
      2.417813,
      NULL,
      0,
      3.962621,
      6.900630,
      1.548050,
      NULL,
      NULL,
      0,
      1.135112,
      1.525248,
      2,
      2,
      0,
      2.487333,
      NULL,
      3,
      NULL,
      0.123984,
      0,
      NULL,
      1.907181,
      0.443178,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '02102',
      '',
      '',
      1.568784,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      2.966778,
      6.054300,
      2,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL);
commit;
end;
/


