set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6905583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '324',
      NULL,
      7.790402,
      57,
      '1434300',
      39,
      0,
      0.103841,
      3,
      '444040',
      0,
      '11- 6-2000',
      17,
      38.035190,
      NULL,
      NULL,
      1,
      0,
      1,
      0.112923,
      1.243527,
      1.882543,
      2,
      0.215287,
      0.008209,
      1,
      0,
      0.888938,
      1.689248,
      0,
      1,
      0.381965,
      1.641696,
      0,
      1,
      1.850183,
      0.906633,
      1.586484,
      0.829671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.046603,
      NULL,
      1.672063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.705461,
      0.839004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.501813,
      1.738275,
      1.815797,
      NULL,
      1,
      1,
      0.751638,
      0.082712,
      0.905681,
      1.353137,
      0,
      1.349803,
      1,
      1.390120,
      0,
      0.849815,
      1.750056,
      1,
      NULL,
      NULL,
      0.529527,
      5.794817,
      NULL,
      0,
      NULL,
      0.291523,
      5.112789,
      0,
      5,
      1.098668,
      0,
      1,
      NULL,
      1.516312,
      4,
      1.085289,
      5,
      4.866045,
      1,
      3,
      4,
      NULL,
      1.851863,
      4,
      1.455079,
      NULL,
      0,
      2.612926,
      1.662915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.024384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.837226,
      NULL,
      NULL,
      NULL,
      NULL,
      5.757326,
      NULL,
      3.824441,
      0.968636,
      1,
      3,
      9,
      1.395249,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.431894,
      2.120062,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      7.468103,
      1.359133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.251430,
      0,
      1.782357,
      NULL,
      2,
      0.634854,
      0.425637,
      1.146852,
      NULL,
      3.825399,
      NULL,
      2.530737,
      1,
      NULL,
      0,
      0.213318,
      0,
      0,
      2.162764,
      NULL,
      3,
      1.184795,
      NULL,
      NULL,
      NULL,
      3.072686,
      1,
      0,
      NULL,
      0,
      NULL,
      0.760595,
      0.610650,
      1,
      1,
      0,
      0.578903,
      0.147807,
      NULL,
      0.366140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      5,
      NULL,
      2.958944,
      2.864102,
      2,
      2,
      0.959659,
      0.007137,
      1.933413);
commit;
end;
/


