set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6905583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '44341412',
      59,
      59,
      '2011002',
      113.847305,
      6,
      3,
      0,
      '422143',
      0.753319,
      ' 0-13-1976',
      55.351500,
      24,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.977298,
      1,
      0,
      0.745615,
      0.303290,
      0.968740,
      1,
      0.778318,
      NULL,
      1.808690,
      1.232948,
      NULL,
      1,
      0.826597,
      0.946403,
      1,
      NULL,
      NULL,
      2.293397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.941742,
      0,
      1.871295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.135370,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202158,
      0.398711,
      0,
      1,
      1,
      NULL,
      0,
      1.512539,
      0.829512,
      1.102803,
      0.673924,
      0,
      1.918573,
      0.862874,
      0.175536,
      1.880235,
      0,
      1,
      1.472886,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.538817,
      NULL,
      1.824650,
      0,
      2,
      1.739750,
      NULL,
      4,
      0,
      0.162956,
      0.446764,
      NULL,
      0.959465,
      4,
      NULL,
      7,
      2,
      0.951640,
      0.266578,
      5.769647,
      NULL,
      4.369967,
      4,
      3.602864,
      0.108195,
      NULL,
      NULL,
      3,
      1.684868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.629627,
      0,
      1,
      0,
      0,
      1.225652,
      1.364170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0,
      2.314737,
      1.444368,
      0.118539,
      3.208467,
      5,
      2.453979,
      1.179669,
      NULL,
      NULL,
      NULL,
      1.094478,
      1,
      0.407839,
      4.057035,
      1,
      2,
      5.728107,
      0.791886,
      NULL,
      NULL,
      1,
      1.880252,
      1.286344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184330,
      3.896390,
      0,
      NULL,
      0.134006,
      1,
      0,
      1,
      NULL,
      2.502661,
      1,
      NULL,
      0.861929,
      1.211427,
      0.311978,
      0.673354,
      2.344758,
      1.559477,
      3,
      0,
      0,
      0.372716,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.744912,
      1.697255,
      0,
      NULL,
      1,
      1.491002,
      0.626194,
      NULL,
      2.540309,
      '23044',
      NULL,
      NULL,
      0.985670,
      '',
      '',
      '',
      1.431289,
      '',
      NULL,
      '',
      3.182160,
      2.413360,
      2.664094,
      1.887800,
      2.925759,
      3.637332,
      3,
      0,
      NULL);
commit;
end;
/


