set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6905583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      20,
      33.076552,
      '2214400',
      136,
      NULL,
      3,
      NULL,
      '044334',
      1,
      '10- 3-1991',
      13,
      48.328835,
      1,
      NULL,
      1,
      2.892940,
      0.225129,
      0.253511,
      1.462729,
      1.452177,
      1.995220,
      0.080756,
      0.821818,
      0.021235,
      1.111167,
      1.363056,
      0.350137,
      1.401414,
      1,
      1,
      NULL,
      0.652276,
      0,
      0.075313,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.791365,
      NULL,
      1,
      0.648045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.034463,
      0.160946,
      0,
      NULL,
      1.222485,
      1,
      1.629917,
      1,
      0.439796,
      0.699861,
      0.225694,
      0,
      1,
      1,
      1,
      1.028645,
      0.989383,
      NULL,
      1.804494,
      NULL,
      NULL,
      0,
      0,
      0,
      0.109792,
      1.340469,
      0.783166,
      1,
      2.208634,
      4.488887,
      1.973545,
      0.863458,
      0.816695,
      NULL,
      0,
      1.011329,
      2.723700,
      7.446061,
      4.367747,
      4,
      0.491256,
      NULL,
      1.795808,
      0.956174,
      3.135587,
      4.933734,
      NULL,
      4,
      0.056456,
      NULL,
      NULL,
      7.852336,
      1.987465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859791,
      1,
      NULL,
      1,
      0,
      1.382145,
      0.828810,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.853612,
      NULL,
      NULL,
      0.672115,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.847825,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.974275,
      3,
      6,
      3,
      NULL,
      1.190100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.558427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      0,
      1.383760,
      0,
      0.515327,
      0,
      2.226136,
      1.841693,
      0.351097,
      1.703398,
      0,
      NULL,
      0.288379,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.613637,
      '13243',
      '20212',
      '',
      1.654151,
      '',
      '',
      '',
      NULL,
      '22131',
      '1442',
      '',
      3.270259,
      NULL,
      2.716459,
      3,
      0.861425,
      0,
      NULL,
      1.855104,
      1.977294);
commit;
end;
/


