set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6905583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41113443',
      13.827463,
      NULL,
      '0420222',
      74,
      4,
      0.962177,
      3,
      '110320',
      4.707715,
      NULL,
      38.547903,
      63.454081,
      1,
      NULL,
      1,
      2.522620,
      0.416346,
      NULL,
      0.300571,
      0.262653,
      2,
      0.520097,
      1.495603,
      1.066215,
      0.996950,
      1,
      1.327673,
      0.867993,
      NULL,
      0.289726,
      NULL,
      1.568888,
      NULL,
      NULL,
      NULL,
      0.629792,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.372176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.439361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196669,
      1,
      0.557192,
      1.487398,
      1.826360,
      0.136640,
      0,
      1,
      0.168036,
      0.098827,
      0,
      1.127606,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.317352,
      0.321652,
      NULL,
      NULL,
      0.504492,
      1,
      NULL,
      NULL,
      1.371312,
      3.735657,
      1.106264,
      NULL,
      2,
      2,
      0,
      0,
      0,
      2,
      0.738599,
      0,
      NULL,
      NULL,
      NULL,
      4.293115,
      NULL,
      NULL,
      0.690309,
      NULL,
      0,
      NULL,
      4.877428,
      1,
      NULL,
      NULL,
      7.112065,
      0.849863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.818944,
      1,
      NULL,
      0.837681,
      1,
      NULL,
      0.920725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.100472,
      1,
      3.612771,
      3.447708,
      0,
      1,
      1,
      0.728742,
      5.111238,
      3,
      3,
      0.472162,
      NULL,
      NULL,
      NULL,
      0.551390,
      0,
      0,
      NULL,
      NULL,
      2,
      1.075389,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.350002,
      1.532339,
      0.400527,
      0.281786,
      2,
      NULL,
      NULL,
      1.676949,
      2,
      0,
      NULL,
      0,
      1.066959,
      0.847964,
      0,
      1,
      NULL,
      0.922932,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '41402',
      '03330',
      '',
      NULL,
      NULL,
      '',
      '',
      5,
      '32001',
      '0443',
      '',
      0,
      4.398203,
      NULL,
      2,
      0.434182,
      NULL,
      NULL,
      0.610188,
      1);
commit;
end;
/


