set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6905583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '143',
      '44234210',
      9.371485,
      69,
      NULL,
      NULL,
      3,
      NULL,
      0,
      '044442',
      3,
      ' 2- 3-1994',
      36.664145,
      65,
      1,
      NULL,
      1.452425,
      2.986013,
      1,
      1,
      1.633754,
      NULL,
      1.792647,
      1,
      1.498685,
      1.054475,
      0,
      1.582218,
      0.538561,
      1.494267,
      NULL,
      0,
      0.329254,
      1.897495,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1.392446,
      0,
      1.287920,
      NULL,
      NULL,
      1.226659,
      NULL,
      NULL,
      NULL,
      0.139422,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.178910,
      NULL,
      0.984836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241101,
      0.524475,
      1.129598,
      NULL,
      1,
      0.560979,
      1.509988,
      1.537512,
      1.462710,
      0.915635,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1.152901,
      0,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      3,
      0.524407,
      NULL,
      NULL,
      NULL,
      2.479934,
      2,
      1.932177,
      1,
      0,
      1.059847,
      0,
      0,
      2.860770,
      3,
      0.770244,
      1,
      NULL,
      5,
      NULL,
      4,
      3,
      0.629695,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236926,
      0,
      1,
      1,
      1,
      1.946738,
      0.011884,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.854804,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.960078,
      0,
      0.790645,
      4.065638,
      4,
      3.695456,
      NULL,
      NULL,
      NULL,
      NULL,
      0.104211,
      3.592463,
      3,
      3,
      NULL,
      1,
      1.007696,
      NULL,
      NULL,
      NULL,
      1.076309,
      0.871030,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.072557,
      0,
      1.500364,
      3.555849,
      0,
      1.563108,
      1.966607,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0.779289,
      NULL,
      0.860635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517123,
      NULL,
      '23020',
      NULL,
      1.241173,
      '',
      NULL,
      '',
      3,
      NULL,
      '',
      NULL,
      5.575173,
      5,
      2,
      5,
      0.564561,
      1.880539,
      3.084559,
      1,
      1);
commit;
end;
/


