set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6905583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33422100',
      0,
      58.775917,
      '1104410',
      NULL,
      NULL,
      0,
      3,
      '142042',
      5,
      '10-28-1987',
      56,
      6,
      1.238421,
      NULL,
      1,
      NULL,
      0,
      1,
      0.631119,
      NULL,
      NULL,
      0.677431,
      1.191043,
      0.352749,
      0,
      0,
      NULL,
      1,
      NULL,
      0.411101,
      NULL,
      NULL,
      0,
      0.193845,
      1.021259,
      0.233417,
      NULL,
      0,
      1.969303,
      0,
      NULL,
      0.232093,
      NULL,
      NULL,
      1.225986,
      NULL,
      NULL,
      NULL,
      0.056840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472391,
      0,
      1.449980,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.972135,
      0.928172,
      1,
      1.231082,
      1.366011,
      0.221174,
      NULL,
      1,
      0.289646,
      1.403649,
      0,
      0.137928,
      0.593526,
      1.117055,
      0.172736,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      2.340840,
      1.203748,
      4.677718,
      NULL,
      4.800933,
      4.822574,
      NULL,
      NULL,
      NULL,
      0.689404,
      3.447175,
      0,
      NULL,
      3.445320,
      3,
      4.978619,
      3.462162,
      1,
      1.017238,
      0,
      1.994309,
      NULL,
      0.539060,
      3.375709,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.838585,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.002934,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.577354,
      3.159741,
      0.725375,
      NULL,
      NULL,
      NULL,
      NULL,
      4.518711,
      2.631877,
      NULL,
      1,
      1,
      0.172280,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.380360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.587180,
      NULL,
      1.298943,
      2.680113,
      3,
      NULL,
      1.219454,
      1,
      2,
      0,
      1,
      0.202845,
      0.473668,
      1,
      NULL,
      0.985602,
      1.659162,
      1.714353,
      0.909026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.947266,
      '24040',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      0,
      '30200',
      NULL,
      NULL,
      5,
      4,
      1,
      1.612707,
      3.605592,
      1,
      2.719256,
      1.306258,
      NULL);
commit;
end;
/


