set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0114098';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3012',
      '21314111',
      68.320744,
      NULL,
      '4202334',
      12.271868,
      4,
      1,
      NULL,
      '141431',
      4.719497,
      ' 6- 1-1984',
      9.200229,
      8,
      1.418478,
      NULL,
      NULL,
      1.163234,
      3,
      0,
      1.655113,
      1,
      1,
      0,
      NULL,
      1,
      6,
      1,
      1,
      0.423886,
      1.926665,
      NULL,
      3.891781,
      0.429202,
      NULL,
      0.791874,
      1.132404,
      1,
      NULL,
      1,
      0.927460,
      1.697553,
      NULL,
      1.699820,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.359685,
      0,
      0.249612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.745890,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0.247652,
      NULL,
      NULL,
      1.481528,
      0.466379,
      NULL,
      1.335670,
      1.553273,
      1.990292,
      NULL,
      0,
      1.353091,
      0,
      2.167347,
      1,
      0,
      2,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.337541,
      0,
      1.256831,
      1.302879,
      NULL,
      1.955744,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424361,
      1.178111,
      3.685931,
      1,
      3.198526,
      2.511582,
      2,
      0.317896,
      NULL,
      1,
      3.395091,
      5.548905,
      5,
      4.305828,
      NULL,
      1.489697,
      1,
      0.131972,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269531,
      5.685702,
      0,
      1,
      1.757956,
      1,
      0.971979,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.995222,
      NULL,
      NULL,
      3,
      NULL,
      0.760280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.791690,
      0.432136,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.877736,
      5,
      4,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.006293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.375498,
      1.445319,
      1,
      1.651027,
      1,
      1,
      3.050282,
      0.120766,
      0,
      0,
      1.152756,
      NULL,
      0,
      1.238649,
      0,
      1.027570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10230',
      '42223',
      '',
      NULL,
      '31103',
      '',
      '',
      1.772532,
      NULL,
      '',
      NULL,
      0.676696,
      2.053823,
      2,
      4,
      3,
      3,
      1,
      1.707019,
      5.455373);
commit;
end;
/


