set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502207';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '331',
      '23',
      4.263619,
      0.727590,
      NULL,
      24.710871,
      6,
      2,
      NULL,
      '022111',
      5.076687,
      ' 6- 8-1991',
      15,
      10.940326,
      NULL,
      NULL,
      0,
      NULL,
      2.356054,
      0,
      1,
      0.610895,
      1,
      3.429889,
      NULL,
      1,
      2.075905,
      0.294431,
      2.797977,
      2.557160,
      0.173076,
      NULL,
      3.417319,
      NULL,
      1.963344,
      1,
      1,
      0,
      2.608539,
      0,
      2.137178,
      3.692054,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.877307,
      NULL,
      0,
      3,
      1,
      NULL,
      0,
      2,
      0.123501,
      1,
      1,
      NULL,
      1.245903,
      NULL,
      0.482426,
      1.595577,
      3,
      2,
      0.380671,
      0.936215,
      1,
      0.027387,
      2.593456,
      NULL,
      1,
      2.762783,
      0,
      NULL,
      NULL,
      0.591466,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      1.046450,
      4.381266,
      0,
      1,
      0.962715,
      0.048178,
      NULL,
      0.471336,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      2.801641,
      0,
      1.156865,
      1.532797,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.188779,
      NULL,
      0,
      4,
      0,
      1.012428,
      3.514410,
      1,
      4,
      1,
      2,
      0.971138,
      5.300590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274830,
      0.684915,
      0,
      1,
      0.070030,
      NULL,
      1.947415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.555640,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.076687,
      1.203502,
      0,
      0.002115,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.391444,
      3.071466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580127,
      0.070784,
      3,
      NULL,
      NULL,
      0.476804,
      0,
      NULL,
      1.265981,
      NULL,
      NULL,
      1.465809,
      1,
      NULL,
      NULL,
      0.156837,
      1.340468,
      1,
      1.178069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '33203',
      NULL,
      0.662900,
      '4141',
      '',
      '',
      0.864060,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


