set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7928776';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '243',
      '31',
      23,
      12,
      '3333133',
      6,
      6,
      3,
      3,
      NULL,
      4.334851,
      ' 8- 3-2000',
      27.719804,
      3,
      NULL,
      NULL,
      1.377401,
      0.833684,
      1.243544,
      0,
      1,
      0,
      2.451800,
      3.712589,
      0.245376,
      0.491420,
      6,
      1,
      NULL,
      NULL,
      0.067046,
      0.252179,
      2,
      1.076866,
      0.079292,
      1.156146,
      0.040585,
      0.111006,
      3.133488,
      1,
      2,
      0.916489,
      1,
      0.118494,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750903,
      3.034800,
      1,
      0,
      NULL,
      3.205308,
      0.789216,
      3.402027,
      2,
      2,
      NULL,
      1.025499,
      1.667154,
      0.674462,
      1.330087,
      0.982914,
      1.560559,
      1.897407,
      1,
      NULL,
      4.557719,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      0.062334,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      0.187094,
      0,
      NULL,
      0.941581,
      0,
      1,
      0,
      0,
      0.180865,
      1,
      NULL,
      NULL,
      1.204274,
      1.964127,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.785765,
      5,
      4.839777,
      NULL,
      2.947483,
      4,
      0.820373,
      5,
      4.789625,
      6,
      0.566858,
      2.583785,
      6.840051,
      NULL,
      NULL,
      1,
      NULL,
      4,
      0.368535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.363194,
      0,
      1.890587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966895,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.448728,
      0,
      0,
      0.407905,
      NULL,
      2,
      0.490639,
      1.597032,
      NULL,
      NULL,
      NULL,
      7,
      1,
      2.047507,
      0,
      2.614981,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.384758,
      0,
      1.889659,
      3,
      0.795398,
      NULL,
      0,
      0.660383,
      3.729010,
      1,
      NULL,
      0.723381,
      NULL,
      0,
      0,
      0,
      0.577721,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.612788,
      '30310',
      NULL,
      '',
      0,
      '2433',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


