set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7928776';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '114',
      '03',
      1,
      NULL,
      NULL,
      15,
      6,
      3.551261,
      NULL,
      '043311',
      2,
      ' 4- 7-2003',
      27.447103,
      1.143393,
      1,
      NULL,
      1.807735,
      0,
      1,
      1,
      1.777426,
      0,
      1,
      3,
      NULL,
      1,
      0,
      0.414414,
      0.236513,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1.169478,
      0.635260,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.379777,
      0,
      2,
      1,
      1.571982,
      NULL,
      2.820135,
      1,
      3.308922,
      NULL,
      3.392065,
      0.759393,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0.042763,
      0.448801,
      0,
      3,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.077623,
      NULL,
      NULL,
      1.912275,
      1,
      NULL,
      1,
      1.567673,
      NULL,
      NULL,
      0.669659,
      1.198495,
      5.305606,
      1,
      0.163333,
      0,
      1,
      0,
      1,
      1,
      0.387751,
      0,
      NULL,
      NULL,
      4.698363,
      1.760473,
      1.522019,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      0.448384,
      0,
      1,
      NULL,
      0,
      1.983011,
      NULL,
      3.563221,
      1.510637,
      NULL,
      9.822591,
      1.087107,
      6.281540,
      6,
      4.784466,
      1.390583,
      3,
      NULL,
      1.362189,
      NULL,
      NULL,
      6.536894,
      1.256012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.299836,
      NULL,
      NULL,
      0,
      3.594364,
      0,
      1.150137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.434221,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.739429,
      1,
      0.897381,
      2,
      1.101235,
      NULL,
      NULL,
      NULL,
      1.373965,
      1,
      0.632843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.191913,
      NULL,
      0,
      NULL,
      NULL,
      2.739306,
      0.513567,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      1.408637,
      0.191162,
      1.350155,
      1.593209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '43012',
      '',
      '',
      0,
      '',
      '',
      '',
      0.658465,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


