set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9767251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11002014',
      0.375400,
      25,
      '3314043',
      11,
      NULL,
      0,
      0,
      '222224',
      3,
      ' 5-28-1976',
      NULL,
      171.564624,
      0.152874,
      NULL,
      4,
      1.664028,
      0,
      0.223483,
      1.819783,
      3,
      0,
      0.576801,
      0.540165,
      1.569056,
      0.969952,
      NULL,
      0.923875,
      0,
      0,
      1.809427,
      0,
      0,
      NULL,
      NULL,
      0.917141,
      0.208770,
      0.072233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.343079,
      1.470465,
      1.915282,
      0.297138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.245738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.274971,
      1,
      1,
      0,
      1.371753,
      1.669965,
      0.682349,
      0.021198,
      1.515971,
      1,
      0.539445,
      1,
      0,
      1.127696,
      0.406697,
      1.304969,
      0,
      1.129119,
      NULL,
      1,
      0,
      0,
      1.894378,
      NULL,
      1.074032,
      0,
      0,
      0.947132,
      0.875536,
      NULL,
      1,
      1,
      1.177061,
      1,
      1.642753,
      NULL,
      0,
      0.863109,
      0.112700,
      1.935013,
      1,
      0,
      0.893714,
      0,
      1,
      NULL,
      0,
      1.182086,
      NULL,
      NULL,
      NULL,
      1.962470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381060,
      0.472324,
      NULL,
      0,
      1.405297,
      1,
      NULL,
      1.039169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220764,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.027837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.958567,
      0,
      1.042515,
      0,
      0.565074,
      0,
      1.815045,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256922,
      1.540554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847248,
      NULL,
      0.145703,
      0.278003,
      0,
      1.488918,
      0,
      1,
      1,
      1.068431,
      1,
      0.073057,
      1.033329,
      1,
      0,
      1,
      0,
      1,
      0.450697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '1143',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      2.105083,
      2,
      0,
      0,
      0,
      2.876155,
      1,
      NULL);
commit;
end;
/


