set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686355';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '214',
      '22341004',
      49,
      55.112722,
      NULL,
      37,
      5,
      2.887831,
      3,
      NULL,
      5.235990,
      ' 7-10-1988',
      NULL,
      NULL,
      1.177557,
      NULL,
      NULL,
      3,
      NULL,
      1.173201,
      0.266726,
      0.780843,
      1.191077,
      1.707434,
      3.299808,
      0.430957,
      0,
      1,
      1.281038,
      1,
      NULL,
      0.926906,
      2,
      NULL,
      0,
      0.765251,
      1,
      0.822193,
      5.050969,
      1,
      3,
      1,
      0.365570,
      NULL,
      NULL,
      NULL,
      0.754231,
      NULL,
      NULL,
      3.634122,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.698661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.199109,
      1.374316,
      NULL,
      1.992387,
      0.146405,
      1,
      NULL,
      1,
      1.218728,
      1,
      1,
      0.836858,
      1,
      1,
      0.512622,
      NULL,
      NULL,
      1.690519,
      NULL,
      0,
      NULL,
      1.201315,
      NULL,
      4,
      1.272878,
      NULL,
      1.427242,
      5.190440,
      0.241593,
      7,
      0,
      NULL,
      0.363434,
      1,
      1,
      1.322845,
      8.855113,
      0.049427,
      8,
      NULL,
      2,
      2,
      8.725875,
      9.696694,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.748973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967839,
      1.004893,
      0,
      1,
      NULL,
      1.541287,
      NULL,
      0.193007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.538764,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      8,
      NULL,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      0.373401,
      9.041961,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.842825,
      0.586831,
      0.718410,
      0,
      0,
      2.755165,
      0,
      NULL,
      0,
      2,
      1.541001,
      1,
      NULL,
      NULL,
      1.897278,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276808,
      '31104',
      '',
      '',
      0.626431,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      2,
      NULL,
      NULL,
      1.221412,
      NULL,
      3,
      0,
      2);
commit;
end;
/


