set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686355';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '133',
      '02040222',
      24.788263,
      22.477336,
      NULL,
      8.768629,
      NULL,
      3.084931,
      0,
      '002141',
      3.163834,
      NULL,
      43,
      NULL,
      0.739352,
      NULL,
      1.211343,
      0,
      0.836349,
      NULL,
      0,
      1.920760,
      NULL,
      0.801299,
      3,
      NULL,
      2,
      0.710993,
      0.923620,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924054,
      1,
      1,
      0.914362,
      5,
      1,
      1,
      NULL,
      1.419419,
      0.606423,
      NULL,
      NULL,
      1.017105,
      NULL,
      NULL,
      1.724873,
      1,
      0.481643,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.669960,
      NULL,
      0,
      1,
      0.219618,
      NULL,
      NULL,
      NULL,
      1.685913,
      NULL,
      NULL,
      1.639551,
      4.219225,
      1,
      0.003801,
      5.306561,
      1,
      0,
      1.850184,
      NULL,
      0.819570,
      0,
      0.052347,
      0.194045,
      0,
      0,
      0.692973,
      NULL,
      0.582068,
      1,
      NULL,
      0.377378,
      3,
      1,
      NULL,
      NULL,
      0,
      6,
      0.706585,
      4,
      3.361468,
      2.719001,
      NULL,
      0.616121,
      0,
      0,
      1.732403,
      NULL,
      9.353632,
      7,
      9,
      6.541485,
      NULL,
      4.774748,
      9.575841,
      8,
      2,
      0.919918,
      NULL,
      0.474571,
      NULL,
      NULL,
      1.845021,
      1.201407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.381455,
      0.345121,
      1.736017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9.573751,
      3,
      0.755615,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.926215,
      1,
      NULL,
      NULL,
      NULL,
      0.220323,
      2,
      5,
      NULL,
      5.600112,
      0,
      0.848303,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570967,
      0.309071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.462069,
      0.179632,
      0,
      2,
      NULL,
      0,
      NULL,
      3,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '00414',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      3.495101,
      3,
      NULL,
      3,
      2,
      2.236958,
      NULL,
      NULL,
      0);
commit;
end;
/


