set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686355';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '303',
      '24321110',
      36,
      79.344270,
      '4234144',
      NULL,
      2,
      2.277222,
      0,
      NULL,
      1,
      ' 9- 3-1980',
      15,
      52,
      0.363755,
      NULL,
      0.198743,
      0.876101,
      1,
      1,
      1,
      0.746375,
      1.814717,
      NULL,
      NULL,
      0,
      4,
      1.069813,
      3,
      1.992705,
      0,
      0.613457,
      NULL,
      1.428690,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      1.726865,
      0.686414,
      1.036025,
      NULL,
      NULL,
      NULL,
      0.275520,
      NULL,
      NULL,
      2,
      1,
      0.754194,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515084,
      1.891193,
      1.339567,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.783375,
      1.352263,
      0.360364,
      0.196646,
      0,
      1.606680,
      0,
      NULL,
      0,
      1,
      1.899671,
      1.836861,
      0.685476,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1.643297,
      1,
      1.598229,
      0,
      NULL,
      1,
      1.390703,
      0,
      2.694888,
      1.931156,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      5.333018,
      2,
      6,
      6,
      3.344689,
      9.791131,
      0,
      NULL,
      NULL,
      3.153152,
      0.479397,
      4,
      2.820030,
      0,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.256914,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.499748,
      NULL,
      1.041924,
      0.959620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.936424,
      0.888402,
      0.067044,
      NULL,
      NULL,
      NULL,
      1,
      4.449471,
      NULL,
      5,
      2.091704,
      0,
      7.701501,
      NULL,
      NULL,
      NULL,
      1,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.204158,
      NULL,
      0,
      0,
      2.523281,
      2.571971,
      3,
      0.935868,
      NULL,
      0,
      1,
      1.469370,
      0,
      1,
      0.344486,
      0.774272,
      0,
      1.728633,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '42012',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      4.738386,
      NULL,
      NULL,
      4,
      NULL,
      0.013531,
      0,
      2,
      3);
commit;
end;
/


