set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686355';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3311',
      '34404331',
      32.297757,
      32.989514,
      '2044103',
      31,
      3,
      3,
      0,
      '342044',
      NULL,
      ' 6-15-1982',
      3.854331,
      NULL,
      0.454591,
      NULL,
      1,
      0.322502,
      NULL,
      1,
      1,
      1.022186,
      NULL,
      1.108217,
      0,
      0,
      0.563796,
      1,
      0.387817,
      0.613922,
      0.590539,
      0.275587,
      3.912201,
      0.257459,
      NULL,
      0.115047,
      1.163276,
      NULL,
      1.506257,
      1,
      0.719127,
      1.314933,
      1.964101,
      NULL,
      NULL,
      NULL,
      1.426164,
      NULL,
      NULL,
      0.922755,
      0.523278,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.625967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.004522,
      0.083213,
      0.953764,
      NULL,
      1.112137,
      1,
      1.084092,
      1,
      0.580316,
      0,
      0,
      NULL,
      1,
      0.793652,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.616257,
      4,
      1.643590,
      1.176700,
      5.281056,
      1.402383,
      0,
      3.776156,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      0,
      1,
      2.058766,
      3.230785,
      2,
      5.181082,
      4,
      6.687808,
      NULL,
      3.842568,
      1,
      4,
      1.533612,
      3,
      0,
      NULL,
      NULL,
      2.408617,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170817,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      1.909471,
      0.554552,
      1.621851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.601112,
      NULL,
      NULL,
      NULL,
      0.637893,
      2.656577,
      6.634003,
      5.514867,
      6,
      1,
      3.018778,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.070368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.449354,
      NULL,
      0.197329,
      1.946191,
      NULL,
      3.219083,
      0,
      0.388162,
      3,
      1.118942,
      1,
      1.636476,
      1.226338,
      1.974037,
      1,
      1,
      NULL,
      1.181277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '04033',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      3.687556,
      NULL,
      NULL,
      NULL,
      3.208485,
      1.809606,
      2);
commit;
end;
/


