set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9872391';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4200',
      NULL,
      38.644333,
      23,
      '3340324',
      3,
      NULL,
      2.652060,
      NULL,
      NULL,
      4.402159,
      ' 8- 4-1984',
      20.352557,
      21.305220,
      1.678005,
      NULL,
      NULL,
      1.679465,
      2,
      1,
      NULL,
      1.168729,
      0.059553,
      NULL,
      1,
      1.884853,
      NULL,
      0,
      0,
      1.462337,
      1,
      1.544930,
      0.042027,
      1.168202,
      0.912610,
      1.772597,
      1,
      1,
      1.423280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783512,
      1,
      NULL,
      0.278007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714445,
      0.604059,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.009096,
      1,
      1,
      NULL,
      1.173556,
      NULL,
      1,
      1,
      1.222931,
      0.932838,
      1.702031,
      0,
      0,
      1.992969,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1.407869,
      4.303158,
      0.991210,
      3,
      0,
      3.605063,
      0,
      NULL,
      0.157198,
      0.284335,
      0,
      3,
      NULL,
      0,
      1,
      0,
      6,
      6,
      9,
      2.691257,
      0.237036,
      5.485005,
      NULL,
      6,
      0,
      6,
      3.140599,
      1.496168,
      NULL,
      NULL,
      2.126781,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.723070,
      0.527844,
      1,
      1,
      1,
      NULL,
      1,
      0.978604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.952265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.716507,
      1,
      0.293478,
      NULL,
      NULL,
      NULL,
      1.816779,
      1,
      1.953895,
      1.320293,
      1.219523,
      NULL,
      0.132393,
      NULL,
      NULL,
      NULL,
      1.221456,
      4.645200,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.426432,
      0.795929,
      2.064744,
      2.728405,
      NULL,
      1,
      2,
      0,
      0.795920,
      0.310227,
      1,
      0.164330,
      NULL,
      1.831586,
      0,
      0.857373,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '03113',
      '',
      NULL,
      NULL,
      '34223',
      '',
      '',
      0.221516,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      0,
      NULL,
      0.633474,
      1.467098,
      3.937905,
      3);
commit;
end;
/


