set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016374';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '04',
      NULL,
      8.663102,
      '1300300',
      23,
      NULL,
      0,
      0,
      '034113',
      3.608895,
      ' 2-25-1985',
      34,
      63,
      NULL,
      NULL,
      4,
      1,
      2.046124,
      1.810023,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      1.677191,
      0.938686,
      0.890114,
      1,
      0.544734,
      NULL,
      1,
      0.752793,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268490,
      1.859814,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.964272,
      1.499753,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      0.915405,
      0,
      NULL,
      1.161151,
      0.271735,
      NULL,
      1.968474,
      0.700430,
      0.508197,
      NULL,
      0.310082,
      2.786464,
      0,
      0.959944,
      1,
      NULL,
      2,
      1.604324,
      7,
      3,
      2.818242,
      2.670469,
      0,
      NULL,
      NULL,
      1,
      4.174300,
      NULL,
      NULL,
      NULL,
      9.605531,
      0.262407,
      1.595216,
      2.021622,
      9,
      4.909274,
      8,
      0,
      NULL,
      NULL,
      NULL,
      8.261812,
      1.716257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.084836,
      NULL,
      0,
      1,
      0.141820,
      1,
      0,
      1.726224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.016032,
      NULL,
      NULL,
      0,
      1,
      0.022670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.551211,
      0.488133,
      1.503581,
      NULL,
      NULL,
      NULL,
      0.359949,
      NULL,
      1.291011,
      2.627350,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.253445,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348793,
      0.110480,
      0.428674,
      0,
      1.696686,
      0.693798,
      2.229653,
      0.188108,
      1,
      1,
      2.068700,
      0.076572,
      0,
      0.356784,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      '14043',
      NULL,
      '',
      1,
      '',
      NULL,
      NULL,
      0.637381,
      '',
      NULL,
      '',
      2.905949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


