set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016374';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '410',
      '32',
      4.959869,
      2.616670,
      '3233201',
      162,
      6,
      1,
      NULL,
      '244114',
      1.881118,
      '11-13-1995',
      11,
      50,
      NULL,
      NULL,
      1.961930,
      NULL,
      3,
      0.049971,
      0.651134,
      3.947596,
      1.835768,
      1.519805,
      1.727154,
      0,
      1,
      0.528392,
      1.682592,
      5.668562,
      1.807986,
      NULL,
      5,
      1.640596,
      NULL,
      0,
      1.701815,
      0.765915,
      2.530884,
      0,
      0.253826,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.117933,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.503773,
      0.071922,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.364409,
      4.407559,
      NULL,
      1.005375,
      NULL,
      NULL,
      2.378999,
      0,
      1,
      0.714582,
      2.343301,
      4.105428,
      0,
      0.584694,
      0,
      1,
      0,
      1.714261,
      0,
      NULL,
      0,
      2.744019,
      0,
      0.088263,
      0,
      NULL,
      3,
      0.366963,
      NULL,
      1,
      1.527212,
      1.528543,
      3,
      0.206024,
      3.496554,
      2.911245,
      1.871057,
      8,
      2,
      0,
      NULL,
      1,
      0,
      4.367822,
      4.124134,
      4.274465,
      0,
      4,
      NULL,
      NULL,
      NULL,
      7.086109,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.103367,
      0,
      1,
      1.156643,
      0,
      3,
      0.029950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.715348,
      NULL,
      3,
      1,
      1.967206,
      0.039126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.488120,
      0,
      6,
      4,
      0.183995,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4.162731,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.355077,
      3,
      1,
      3.744524,
      1.767076,
      1.714685,
      1.709017,
      0.180168,
      0.085968,
      1.156108,
      0.360899,
      0,
      2,
      1,
      NULL,
      NULL,
      2.714976,
      1,
      0,
      1,
      0,
      2,
      NULL,
      1.188370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.059729,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831591,
      NULL,
      NULL,
      NULL,
      NULL,
      2.586526,
      NULL,
      1.217735,
      NULL,
      0.795420,
      1.970724,
      1,
      2,
      1,
      NULL,
      '',
      '',
      1.378132,
      '',
      '',
      NULL,
      1.431799,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


