set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016374';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14',
      28.994468,
      39.180978,
      '4042330',
      41,
      2,
      3.318363,
      2,
      '122020',
      5,
      '10- 4-1997',
      0,
      30,
      0,
      NULL,
      7,
      2.146729,
      NULL,
      1.943810,
      0.356228,
      0.201864,
      1,
      0,
      3.021917,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.537858,
      1.500915,
      NULL,
      1,
      1.087594,
      1.614709,
      1,
      1.075305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.317212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.624694,
      0.528529,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.476794,
      NULL,
      0,
      1.871299,
      1.999104,
      0,
      1,
      1.336733,
      0.513747,
      2,
      1,
      0,
      1.922425,
      0.982436,
      1,
      NULL,
      1.563910,
      1.900651,
      NULL,
      0.121650,
      2.514811,
      1,
      1,
      1.371603,
      0.921205,
      5.532423,
      NULL,
      1.667410,
      2,
      4.675069,
      0,
      1,
      NULL,
      1.905559,
      0,
      4.143321,
      8,
      6.616244,
      3.548270,
      2,
      NULL,
      5.037885,
      NULL,
      NULL,
      2.979131,
      1,
      NULL,
      1.666885,
      NULL,
      NULL,
      4,
      3.959370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1.091693,
      0.873794,
      0.078862,
      2.695752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.362955,
      NULL,
      9.440817,
      0,
      1,
      0.009974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.304080,
      1.344684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6.352761,
      5.958779,
      0,
      0.886633,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.089100,
      2,
      3,
      NULL,
      6.669462,
      NULL,
      1.260243,
      0.554886,
      NULL,
      1.527856,
      1,
      3,
      2.695487,
      0.789638,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795802,
      1.006430,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.796019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '43343',
      '',
      '',
      0.956118,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      3.766315,
      3,
      3.054262,
      3,
      3,
      3,
      3.394809,
      1,
      3.036357);
commit;
end;
/


