set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9428112';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-5-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '4221143',
      13.463707,
      4,
      0,
      3,
      '124214',
      0.682281,
      ' 2- 2-1995',
      17.741248,
      NULL,
      0.424740,
      NULL,
      2,
      2,
      NULL,
      1.666839,
      3.132340,
      1.946161,
      1,
      0.000128,
      1.778797,
      NULL,
      0.866229,
      NULL,
      1.235182,
      NULL,
      0.862316,
      1.447839,
      1.143028,
      NULL,
      1,
      0,
      0.705938,
      1.358261,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.132629,
      0.385606,
      NULL,
      0,
      1,
      0.489772,
      0,
      0,
      NULL,
      1.136047,
      0,
      0.304270,
      1.568788,
      0,
      1,
      1.974939,
      0.302817,
      1,
      0.547037,
      4,
      1,
      1,
      1.172678,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.580500,
      0,
      1.987493,
      0,
      0,
      0.777806,
      1,
      1,
      0.271026,
      1.445832,
      0.984541,
      0,
      NULL,
      NULL,
      0.863597,
      1.289611,
      NULL,
      1,
      NULL,
      0,
      4,
      1,
      1,
      0.770450,
      0.539260,
      NULL,
      1,
      NULL,
      6,
      7.373832,
      1.378013,
      0.524773,
      2,
      NULL,
      NULL,
      1.415799,
      3.416559,
      0.128851,
      NULL,
      4.929373,
      NULL,
      1.368218,
      5,
      1.090666,
      4.828840,
      11.114744,
      3.166529,
      NULL,
      NULL,
      NULL,
      5.795097,
      1.565144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.387256,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0.879037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918653,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992547,
      0,
      NULL,
      NULL,
      NULL,
      0.124756,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.217791,
      1.901251,
      0.449436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.441994,
      0,
      2,
      2,
      1.073511,
      1.779444,
      0.574621,
      NULL,
      NULL,
      NULL,
      0.618333,
      1.321400,
      0.819851,
      NULL,
      0.990111,
      0.881801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '03204',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


