set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9428112';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      32,
      14,
      '3203101',
      NULL,
      NULL,
      1.924296,
      3,
      '222014',
      4,
      ' 9-21-1990',
      15.840304,
      23,
      1,
      NULL,
      2.853008,
      NULL,
      1.890922,
      0,
      1.321154,
      1.370333,
      0.644295,
      0,
      3.465480,
      0.699206,
      1,
      1,
      0,
      1.161393,
      1.481603,
      0,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.881408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.808881,
      1.173878,
      0.257699,
      1.293682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836557,
      1,
      NULL,
      1.413645,
      3.926199,
      1.973330,
      1,
      1,
      0,
      0.739478,
      1,
      NULL,
      0.518444,
      1.399354,
      1.564135,
      NULL,
      0.929741,
      1.802849,
      NULL,
      NULL,
      0.278426,
      1.927251,
      NULL,
      0.050169,
      NULL,
      NULL,
      NULL,
      0,
      0.170347,
      3,
      4,
      3.911726,
      1.052650,
      1.926384,
      1.353237,
      NULL,
      0.806289,
      3.273274,
      5.986322,
      1,
      0.129388,
      0.098749,
      1,
      5.410816,
      2,
      NULL,
      4,
      3.469263,
      0.826857,
      NULL,
      NULL,
      1,
      0.253434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245614,
      0.017313,
      1,
      NULL,
      1.720834,
      1,
      1.279994,
      0.016012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.157980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5,
      4.411263,
      1.447482,
      NULL,
      1.627418,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.929017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155566,
      1.987474,
      NULL,
      0,
      3.672833,
      1.623637,
      0,
      0.134603,
      0,
      1.629669,
      1.217510,
      1,
      1.317466,
      NULL,
      NULL,
      1.527867,
      1,
      0,
      1.790226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.879192,
      '22331',
      '',
      '',
      1.406525,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      4.499553,
      1.502065,
      4.627400,
      2,
      NULL,
      NULL,
      2.812378,
      NULL);
commit;
end;
/


